/*
1. LinkData.getSubjectsについて
　先頭から1万ちょっとまでしか取得できないっぽい
　ファイルを分割して対処
2. LinkData.getObjectsについて
　たまに500エラーで落ちる事がある（そうなるとコールバック関数は実行されない）
　エラートラップの仕方が分からんのでDeferredに頼らずデータが格納されたかどうかで成否を判別する
*/

var RDF = {
	"tree" : {
		"2000000000":{},
		"2A00000000":{},
		"2AA0000000":{
			"2AAA000000":{"1AAA000100":{},"1AAA000200":{},"1AAA000300":{},"1AAA000400":{},"1AAA000500":{}},
			"2AAB000000":{"1AAB000600":{},"1AAB000700":{},"1AAB000800":{},"1AAB000900":{},"1AAB001000":{},"1AAB001100":{},"1AAB001200":{}},
			"2AAC000000":{"1AAC001300":{},"1AAC001400":{}},
			"2AAD000000":{"1AAD001500":{},"1AAD001600":{},"1AAD001700":{},"1AAD001800":{},"1AAD001900":{},"1AAD002000":{},"1AAD002100":{},"1AAD002200":{},"1AAD002300":{}},
			"2AAE000000":{"1AAE002400":{},"1AAE002500":{},"1AAE002600":{}},
			"2AAF000000":{"1AAF002700":{},"1AAF002800":{},"1AAF002900":{},"1AAF003000":{}}
		},
		"2AB0000000":{
			"2ABA000000":{"1ABA003100":{},"1ABA003200":{},"1ABA003300":{},"1ABA003400":{},"1ABA003500":{},"1ABA003600":{}},
			"2ABB000000":{"1ABB003700":{},"1ABB003800":{},"1ABB003900":{},"1ABB004000":{}},
			"2ABC000000":{"1ABC004100":{},"1ABC004200":{},"1ABC004300":{},"1ABC004400":{},"1ABC004500":{}},
			"2ABD000000":{"1ABD004600":{},"1ABD004700":{},"1ABD004800":{}}
		},
		"2AC0000000":{
			"2ACA000000":{"1ACA004900":{},"1ACA005000":{},"1ACA005100":{}},
			"2ACB000000":{"1ACB005200":{},"1ACB005300":{},"1ACB005400":{},"1ACB005500":{},"1ACB005600":{},"1ACB005700":{}},
			"2ACC000000":{"1ACC005800":{},"1ACC005900":{},"1ACC006000":{},"1ACC006100":{},"1ACC006200":{},"1ACC006300":{}},
			"2ACD000000":{"1ACD006400":{},"1ACD006500":{},"1ACD006600":{},"1ACD006700":{},"1ACD006800":{},"1ACD006900":{},"1ACD007000":{},"1ACD007100":{},"1ACD007200":{},"1ACD007300":{},"1ACD007400":{},"1ACD007500":{},"1ACD007600":{},"1ACD007700":{},"1ACD007800":{},"1ACD007900":{}}
		},
		"2AD0000000":{},
		"2ADA000000":{
			"2ADAA00000":{"1ADAA08000":{},"1ADAA08100":{},"1ADAA08200":{},"1ADAA08300":{},"1ADAA08400":{}},
			"2ADAB00000":{"1ADAB08600":{},"1ADAB08700":{},"1ADAB08800":{},"1ADAB08900":{},"1ADAB09000":{},"1ADAB09100":{},"1ADAB09200":{},"1ADAB09300":{},"1ADAB09400":{}},
			"2ADAC00000":{"1ADAC09500":{},"1ADAC09600":{},"1ADAC09700":{}},
			"2ADAD00000":{"1ADAD09800":{},"1ADAD09900":{},"1ADAD10000":{}},
			"2ADAE00000":{"1ADAE10100":{},"1ADAE10200":{},"1ADAE10300":{},"1ADAE10400":{},"1ADAE10500":{},"1ADAE10600":{},"1ADAE10700":{}}
		},
		"2ADB000000":{
			"2ADBA00000":{"1ADBA10800":{},"1ADBA10900":{},"1ADBA11000":{},"1ADBA11100":{},"1ADBA11200":{}},
			"2ADBB00000":{"1ADBB11300":{},"1ADBB11400":{},"1ADBB11500":{}},
			"2ADBC00000":{"1ADBC11600":{},"1ADBC11700":{},"1ADBC11800":{}},
			"2ADBD00000":{"1ADBD11900":{},"1ADBD12000":{}},
			"2ADBE00000":{"1ADBE12100":{},"1ADBE12200":{}},
			"2ADBF00000":{"1ADBF12300":{},"1ADBF12400":{},"1ADBF12500":{}},
			"2ADBG00000":{"1ADBG12600":{},"1ADBG12700":{},"1ADBG12800":{},"1ADBG12900":{}},
			"2ADBH00000":{"1ADBH13000":{},"1ADBH13100":{},"1ADBH13200":{}},
			"2ADBI00000":{"1ADBI13300":{},"1ADBI13400":{},"1ADBI13500":{}},
			"2ADBJ00000":{"1ADBJ13600":{},"1ADBJ13700":{},"1ADBJ13800":{}},
			"2ADBK00000":{"1ADBK13900":{},"1ADBK14000":{},"1ADBK14100":{},"1ADBK14200":{}},
			"2ADBL00000":{"1ADBL14300":{}}
		},
		"2ADC000000":{
			"2ADCA00000":{"1ADCA14400":{},"1ADCA14500":{},"1ADCA14600":{},"1ADCA14700":{},"1ADCA14800":{},"1ADCA14900":{},"1ADCA15000":{},"1ADCA15100":{},"1ADCA15200":{}},
			"2ADCB00000":{"1ADCB15300":{}},
			"2ADCC00000":{"1ADCC15400":{},"1ADCC15500":{},"1ADCC15600":{}}
		},
		"2AE0000000":{
			"2AEA000000":{"1AEA015700":{},"1AEA015800":{},"1AEA015900":{},"1AEA016000":{},"1AEA016100":{},"1AEA016200":{},"1AEA016300":{},"1AEA016400":{},"1AEA016500":{},"1AEA016600":{},"1AEA016700":{},"1AEA016800":{},"1AEA016900":{}},
			"2AEB000000":{"1AEB017000":{},"1AEB017100":{},"1AEB017200":{},"1AEB017300":{}},
			"2AEC000000":{"1AEC017400":{},"1AEC017500":{},"1AEC017600":{},"1AEC017700":{},"1AEC017800":{},"1AEC017900":{}},
			"2AED000000":{"1AED018000":{}}
		},
		"2AF0000000":{
			"2AFA000000":{"1AFA018100":{},"1AFA018200":{},"1AFA018300":{},"1AFA018400":{},"1AFA018500":{},"1AFA018600":{}},
			"2AFB000000":{"1AFB018700":{},"1AFB018800":{},"1AFB018900":{},"1AFB019000":{}},
			"2AFC000000":{"1AFC019100":{},"1AFC019200":{},"1AFC019300":{},"1AFC019400":{},"1AFC019500":{},"1AFC019600":{},"1AFC019700":{},"1AFC019800":{},"1AFC019900":{},"1AFC020000":{}},
			"2AFD000000":{"1AFD020100":{},"1AFD020200":{},"1AFD020300":{},"1AFD020400":{},"1AFD020500":{},"1AFD020600":{},"1AFD020700":{},"1AFD020800":{},"1AFD020900":{},"1AFD021000":{}},
			"2AFE000000":{"1AFE021100":{},"1AFE021200":{},"1AFE021300":{},"1AFE021400":{},"1AFE021500":{},"1AFE021600":{}},
			"2AFF000000":{"1AFF021700":{},"1AFF021800":{},"1AFF021900":{},"1AFF022000":{}},
			"2AFG000000":{"1AFG022100":{},"1AFG022200":{},"1AFG022300":{},"1AFG022400":{}},
			"2AFH000000":{"1AFH022500":{},"1AFH022600":{},"1AFH022700":{},"1AFH022800":{},"1AFH022900":{}},
			"2AFI000000":{"1AFI023000":{}}
		},
		"2AG0000000":{
			"2AGA000000":{"1AGA023100":{},"1AGA023200":{},"1AGA023300":{},"1AGA023400":{},"1AGA023500":{},"1AGA023600":{}},
			"2AGB000000":{"1AGB023700":{},"1AGB023800":{},"1AGB023900":{},"1AGB024000":{},"1AGB024100":{}},
			"2AGC000000":{"1AGC024200":{},"1AGC024300":{},"1AGC024400":{},"1AGC024500":{},"1AGC024600":{},"1AGC024700":{}},
			"2AGD000000":{"1AGD024800":{},"1AGD024900":{},"1AGD025000":{},"1AGD025100":{}}
		},
		"2AH0000000":{
			"2AHA000000":{"1AHA025200":{},"1AHA025300":{},"1AHA025400":{}},
			"2AHB000000":{"1AHB025500":{},"1AHB025600":{}},
			"2AHC000000":{"1AHC025700":{},"1AHC025800":{},"1AHC025900":{}},
			"2AHD000000":{"1AHD026000":{}},
			"2AHE000000":{"1AHE026100":{},"1AHE026200":{},"1AHE026300":{},"1AHE026400":{},"1AHE026500":{},"1AHE026600":{}},
			"2AHF000000":{"1AHF026700":{}},
			"2AHG000000":{"1AHG026800":{}},
			"2AHH000000":{"1AHH026900":{},"1AHH027000":{}},
			"2AHI000000":{"1AHI027100":{}}
		},
		"2AH000000A":{},
		"2AI0000000":{
			"2AIA000000":{"1AIA027400":{},"1AIA027500":{},"1AIA027600":{},"1AIA027700":{},"1AIA027800":{},"1AIA027900":{},"1AIA028000":{},"1AIA028100":{}},
			"2AIB000000":{"1AIB028200":{},"1AIB028300":{},"1AIB028400":{},"1AIB028500":{},"1AIB028600":{},"1AIB028700":{},"1AIB028800":{},"1AIB028900":{}},
			"2AIC000000":{"1AIC029000":{},"1AIC029100":{},"1AIC029200":{},"1AIC029300":{}},
			"2AID000000":{"1AID029400":{},"1AID029500":{},"1AID029600":{}},
			"2AIE000000":{"1AIE029700":{},"1AIE029800":{},"1AIE029900":{},"1AIE030000":{},"1AIE030100":{},"1AIE030200":{},"1AIE030300":{}}
		},
		"2AJ0000000":{
			"2AJA000000":{"1AJA030400":{},"1AJA030500":{}},
			"2AJB000000":{"1AJB030600":{},"1AJB030700":{},"1AJB030800":{}},
			"2AJC000000":{"1AJC030900":{},"1AJC031000":{},"1AJC031100":{},"1AJC031200":{}},
			"2AJD000000":{"1AJD031300":{},"1AJD031400":{}},
			"2AJE000000":{"1AJE031500":{},"1AJE031600":{},"1AJE031700":{},"1AJE031800":{}},
			"2AJF000000":{"1AJF031900":{},"1AJF032000":{},"1AJF032100":{},"1AJF032200":{},"1AJF032300":{}},
			"2AJG000000":{"1AJG032400":{},"1AJG032500":{},"1AJG032600":{},"1AJG032700":{},"1AJG032800":{},"1AJG032900":{},"1AJG033000":{},"1AJG033100":{},"1AJG033200":{}},
			"2AJH000000":{"1AJH033300":{},"1AJH033400":{},"1AJH033500":{},"1AJH033600":{},"1AJH033700":{},"1AJH033800":{},"1AJH033900":{},"1AJH034000":{},"1AJH034100":{},"1AJH034200":{},"1AJH034300":{},"1AJH034400":{},"1AJH034500":{},"1AJH034600":{}},
			"2AJI000000":{"1AJI034700":{}},
			"2AJJ000000":{"1AJJ034800":{}},
			"2AJK000000":{"1AJK034900":{},"1AJK035000":{},"1AJK035100":{},"1AJK035200":{}},
			"2AJL000000":{"1AJL035300":{},"1AJL035400":{},"1AJL035500":{},"1AJL035600":{},"1AJL035700":{},"1AJL035800":{},"1AJL035900":{},"1AJL036000":{},"1AJL036100":{},"1AJL036200":{}},
			"2AJM000000":{"1AJM036300":{},"1AJM036400":{},"1AJM036500":{}}
		},
		"2AJ000000A":{},
		"2AK0000000":{
			"2AKA000000":{"1AKA036700":{},"1AKA036800":{},"1AKA036900":{},"1AKA037000":{},"1AKA037100":{},"1AKA037200":{},"1AKA037300":{},"1AKA037400":{},"1AKA037500":{}},
			"2AKB000000":{"1AKB037600":{}}
		},
		"2AL0000000":{},
		"2AM0000000":{
			"2AMA000000":{"1AMA038700":{}},
			"2AMB000000":{"1AMB038800":{},"1AMB038900":{},"1AMB039000":{},"1AMB039100":{},"1AMB039200":{},"1AMB039300":{}},
			"2AMC000000":{"1AMC039400":{},"1AMC039500":{}},
			"2AMD000000":{"1AMD039600":{},"1AMD039700":{}}
		},
		"2AN0000000":{
			"2ANA000000":{"1ANA039800":{}},
			"2ANB000000":{"1ANB039900":{},"1ANB040000":{}},
			"2ANC000000":{"1ANC040100":{}},
			"2AND000000":{"1AND040200":{},"1AND040300":{},"1AND040400":{},"1AND040500":{},"1AND040600":{}},
			"2ANE000000":{"1ANE040700":{},"1ANE040800":{},"1ANE040900":{}},
			"2ANF000000":{"1ANF041000":{},"1ANF041100":{},"1ANF041200":{},"1ANF041300":{}},
			"2ANG000000":{"1ANG041400":{},"1ANG041500":{},"1ANG041600":{},"1ANG041700":{}}
		},
		"2AO0000000":{
			"2AOA000000":{},
			"2AOB000000":{},
			"2AOE000000":{},
			"2AOG000000":{},
			"2AOH000000":{}
		},
		"2AP0000000":{},
		"2APA000000":{},
		"2APB000000":{
			"2APBA00000":{"1APBA45600":{},"1APBA45700":{},"1APBA45800":{},"1APBA45900":{},"1APBA46000":{},"1APBA46100":{},"1APBA46200":{},"1APBA46300":{}},
			"2APBB00000":{"1APBB46400":{},"1APBB46500":{},"1APBB46600":{}}
		},
		"2APC000000":{},
		"2APD000000":{},
		"2APE000000":{
			"2APEA00000":{"1APEA47400":{},"1APEA47500":{}},
			"2APEB00000":{"1APEB47600":{},"1APEB47700":{}},
			"2APEC00000":{"1APEC47800":{},"1APEC47900":{},"1APEC48000":{}},
			"2APED00000":{"1APED48100":{},"1APED48200":{}},
			"2APEE00000":{"1APEE48300":{}}
		},
		"2B00000000":{},
		"2C00000001":{
			"2C00000002":{"1AL0037700":{},"1AL0037800":{},"1AL0037900":{},"1AL0038000":{},"1AL0038100":{},"1AL0038200":{},"1AL0038300":{},"1AL0038400":{},"1AL0038500":{},"1AL0038600":{},"1APA045000":{},"1APA045100":{},"1APA045200":{},"1APA045300":{},"1APA045400":{},"1APA045500":{},"1APC046700":{},"1APC046800":{},"1APC046900":{},"1APD047000":{},"1B00048500":{},"1B00048600":{},"1B00048700":{},"1CAA050100":{},"1CAA050200":{},"1CAB050300":{},"1CAC050400":{}}
		},
		"2CAA000000":{},
		"4000000300":{},
		"4000000301":{},
		"4000000302":{},
		"4000000303":{
			"4000000305":{},
			"4000000306":{},
			"4000000310":{},
			"4000000311":{},
			"4000000312":{}
		},
		"4000000304":{},
		"4000000313":{
			"4000000314":{},
			"4000000315":{}
		},
		"4000000316":{},
		"4000000317":{
			"4000000318":{},
			"4000000320":{},
			"4000000321":{},
			"4000000322":{}
		},
		"4000000323":{
			"4000000327":{}
		},
		"4000000328":{},
		"4000000329":{},
		"4000000330":{}
	},
	"baseYear" : "2010",
	"minMonth" : "201001",
	"maxMonth" : "201012",
	"current" : {
		"year" : "2010",
		"item" : "1",
		"type" : "2",
		"unit" : "1"
	},
	"getWorks" : function() {
		var d = $.Deferred(),
			timer, count = 0;
		timer = setInterval(function() {
			if (typeof RDF.works !== "undefined") {
				d.resolve();
				clearInterval(timer);
			} else if (count === 0) {
				LinkData.getWorks(function(works) {
					RDF.works = works;
				});
				count = 50;
			} else {
				count--;
			}
		}, 100);
		return d.promise();
	},
	"getFiles" : function(work) {
		var d = $.Deferred(),
			timer, count = 0;
		RDF.files = RDF.files || {};
		timer = setInterval(function() {
			if (typeof RDF.files[work] !== "undefined") {
				d.resolve();
				clearInterval(timer);
			} else if (count === 0) {
				LinkData.getFiles(work, function(files) {
					RDF.files[work] = files;
				});
				count = 50;
			} else {
				count--;
			}
		}, 100);
		return d.promise();
	},
	"getSubjects" : function(work, file) {
		var d = $.Deferred(),
			timer, count = 0;
		RDF.subjects = RDF.subjects || {};
		RDF.subjects[work] = RDF.subjects[work] || {};
		timer = setInterval(function() {
			if (typeof RDF.subjects[work][file] !== "undefined") {
				d.resolve();
				clearInterval(timer);
			} else if (count === 0) {
				LinkData.getSubjects(work, file, function(subjs) {
					RDF.subjects[work][file] = subjs;
				});
				count = 50;
			} else {
				count--;
			}
		}, 100);
		return d.promise();
	},
	"getProperties" : function(work, file) {
		var d = $.Deferred(),
			timer, count = 0;
		RDF.properties = RDF.properties || {};
		RDF.properties[work] = RDF.properties[work] || {};
		timer = setInterval(function() {
			if (typeof RDF.properties[work][file] !== "undefined") {
				d.resolve();
				clearInterval(timer);
			} else if (count === 0) {
				LinkData.getProperties(work, file, function(props) {
					RDF.properties[work][file] = props;
				});
				count = 50;
			} else {
				count--;
			}
		}, 100);
		return d.promise();
	},
	"getObjects" : function(work, file, subj, prop) {
		var d = $.Deferred(),
			timer, count = 0;
		RDF.objects = RDF.objects || {};
		RDF.objects[work] = RDF.objects[work] || {};
		RDF.objects[work][file] = RDF.objects[work][file] || {};
		RDF.objects[work][file][subj] = RDF.objects[work][file][subj] || {};
		timer = setInterval(function() {
			if (typeof RDF.objects[work][file][subj][prop] !== "undefined") {
				d.resolve();
				clearInterval(timer);
			} else if (count === 0) {
				LinkData.getObjects(work, file, subj, prop, function(objes) {
					if (objes.length === 0) {
						RDF.objects[work][file][subj][prop] = null;
					} else {
						RDF.objects[work][file][subj][prop] = objes[0];
					}
				});
				count = 50;
			} else {
				count--;
			}
		}, 100);
		return d.promise();
	},
	//年月（YYYYMM）の最小値を調べる
	"getMin" : function() {
		var d = $.Deferred(),
			year = RDF.baseYear,
			i, j, work, file;
		//最小年を取得
		for (i = 0; i < RDF.works.length; i++) {
			for (j = 0; j < RDF.files[RDF.works[i]].length; j++) {
				if (year > RDF.files[RDF.works[i]][j].substr(17, 4)) {
					year = RDF.files[RDF.works[i]][j].substr(17, 4);
					work = RDF.works[i];
				}
			}
		}
		//最小年のファイルのサブジェクトから最小年月を取得
		file = "IIP_Base" + RDF.baseYear + "_Year" + year + "_Production";
		RDF.getSubjects(work, file)
			.pipe(function() {
				for (i = 0; i < RDF.subjects[work][file].length; i++) {
					if (RDF.minMonth > RDF.subjects[work][file][i].substr(-7, 6)) {
						RDF.minMonth = RDF.subjects[work][file][i].substr(-7, 6);
					}
				}
				d.resolve();
			});
		return d.promise();
	},
	//年月（YYYYMM）の最大値を調べる
	"getMax" : function() {
		var d = $.Deferred(),
			year = RDF.baseYear,
			i, j, work, file;
		//最大年を取得
		for (i = 0; i < RDF.works.length; i++) {
			for (j = 0; j < RDF.files[RDF.works[i]].length; j++) {
				if (year < RDF.files[RDF.works[i]][j].substr(17, 4)) {
					year = RDF.files[RDF.works[i]][j].substr(17, 4);
					work = RDF.works[i];
				}
			}
		}
		//最大年のファイルのサブジェクトから最大年月を取得
		file = "IIP_Base" + RDF.baseYear + "_Year" + year + "_Production";
		RDF.getSubjects(work, file)
			.pipe(function() {
				for (i = 0; i < RDF.subjects[work][file].length; i++) {
					if (RDF.maxMonth < RDF.subjects[work][file][i].substr(-7, 6)) {
						RDF.maxMonth = RDF.subjects[work][file][i].substr(-7, 6);
					}
				}
				d.resolve();
			});
		return d.promise();
	},
	//RDF.treeの中から指定された品目番号のノードを探して渡す
	"getNode" : function(code) {
		var lv1, lv2, lv3;
		for (lv1 in RDF.tree) {
			if (lv1 === code) {
				return RDF.tree[lv1];
			} else if (Object.keys(RDF.tree[lv1]).length !== 0) {
				for (lv2 in RDF.tree[lv1]) {
					if (lv2 === code) {
						return RDF.tree[lv1][lv2];
					} else if (Object.keys(RDF.tree[lv1][lv2]).length !== 0) {
						for (lv3 in RDF.tree[lv1][lv2]) {
							if (lv3 === code) {
								return RDF.tree[lv1][lv2][lv3];
							}
						}
					}
				}
			}
		}
		return false;
	},
	//指定されたファイルを含むワーク名を返す
	"getWorkFromFile" : function(file) {
		var i, j;
		for (i = 0; i < RDF.works.length; i++) {
			for (j = 0; j < RDF.files[RDF.works[i]].length; j++) {
				if (RDF.files[RDF.works[i]][j] === file) {
					return RDF.works[i];
				}
			}
		}
	},
	//品目の名称を取得してテーブルを埋める（基準年の生産のファイルから）
	"fillName" : function(code) {
		var d = $.Deferred(),
			work, file, subj, prop,
			deferreds;
		file = "IIP_Base" + RDF.baseYear + "_Year" + RDF.baseYear + "_Production";
		work = RDF.getWorkFromFile(file);
		subj = "http://linkdata.org/resource/" + work + "#" + code + RDF.baseYear + "011";
		prop = "http://linkdata.org/property/" + work + "#name";
		if (typeof RDF.objects === "undefined" ||
			typeof RDF.objects[work] === "undefined" ||
			typeof RDF.objects[work][file] === "undefined" ||
			typeof RDF.objects[work][file][subj] === "undefined" ||
			typeof RDF.objects[work][file][subj][prop] === "undefined") {
			deferreds = [ RDF.getObjects(work, file, subj, prop) ];
			$.when.apply($, deferreds).done(function() {
				$("#" + code + " td:nth-child(2)").text(RDF.objects[work][file][subj][prop]);
				d.resolve();
			});
		} else {
			$("#" + code + " td:nth-child(2)").text(RDF.objects[work][file][subj][prop]);
			d.resolve();
		}
		return d.promise();
	},
	//データを取得してテーブルを埋める
	//currentJsonは関数呼び出し時点のRDF.currentをJSON文字列化したもの
	//データ取得に時間かかってRDF.currentが変化していたら書き込まない
	"fillData" : function(code, index, currentJson) {
		var d = $.Deferred(),
			work, file, subj, prop, deferreds,
			lastMonth, lastWork, lastFile, lastSubj,
			outerSize, tableSize,
			lastCurrent = JSON.parse(currentJson);
		//ファイル
		switch (lastCurrent.item) {
			case "1":
				file = "IIP_Base" + RDF.baseYear + "_Year" + lastCurrent.year + "_Production";
				break;
			case "3":
				file = "IIP_Base" + RDF.baseYear + "_Year" + lastCurrent.year + "_Shipments";
				break;
			case "4":
				file = "IIP_Base" + RDF.baseYear + "_Year" + lastCurrent.year + "_Inventory";
				break;
			case "5":
				file = "IIP_Base" + RDF.baseYear + "_Year" + lastCurrent.year + "_InventoryRatio";
				break;
		}
		//ワーク
		work = RDF.getWorkFromFile(file);
		//サブジェクト
		subj = "http://linkdata.org/resource/" + work + "#" + code + (lastCurrent.year * 100 + index) + lastCurrent.item;
		//前月か前年同月
		if (lastCurrent.unit === "2") {
			if (index === 1) {
				lastMonth = String((lastCurrent.year - 1) * 100 + 12);
			} else {
				lastMonth = String(lastCurrent.year * 100 + index - 1);
			}
		} else if (lastCurrent.unit === "3") {
			lastMonth = String((lastCurrent.year - 1) * 100 + index);
		}
		//プロパティ
		switch (lastCurrent.type) {
			case "1":
				prop = "http://linkdata.org/property/" + work + "#original_index";
				break;
			case "2":
				prop = "http://linkdata.org/property/" + work + "#seasonally_adjusted_index";
				break;
		}
		//オブジェクトを問い合わせてテーブルに書き込み
		deferreds = [ RDF.getObjects(work, file, subj, prop) ];
		if (lastCurrent.unit !== "1") {
			lastFile = file.substr(0, 17) + lastMonth.substr(0, 4) + file.substr(21);
			lastWork = RDF.getWorkFromFile(lastFile);
			lastSubj = "http://linkdata.org/resource/" + lastWork + "#" + code + lastMonth + lastCurrent.item;
			deferreds.push(RDF.getObjects(lastWork, lastFile, lastSubj, prop));
		}
		$.when.apply($, deferreds).done(function() {
			if (JSON.stringify(RDF.current) === currentJson) {
				if (lastCurrent.unit === "1") {
					if (RDF.objects[work][file][subj][prop] === null) {
						$("#" + code + " td:nth-child(" + (index + 2) + ")").text("-");
					} else {
						$("#" + code + " td:nth-child(" + (index + 2) + ")").text(Number(RDF.objects[work][file][subj][prop]).toFixed(1));
					}
				} else {
					if (RDF.objects[lastWork][lastFile][lastSubj][prop]) {
						if (RDF.objects[work][file][subj][prop] === null) {
							$("#" + code + " td:nth-child(" + (index + 2) + ")").text("-");
						} else {
							$("#" + code + " td:nth-child(" + (index + 2) + ")").text(Number(Math.round(RDF.objects[work][file][subj][prop] / RDF.objects[lastWork][lastFile][lastSubj][prop] * 1000) / 10).toFixed(1));
						}
					} else {
						$("#" + code + " td:nth-child(" + (index + 2) + ")").text("-");
					}
				}
			}
			//メニューをリサイズ
			outerSize = Math.floor(($("#outer").width() - 3) / 4);
			tableSize = Math.floor(($("table").width() - 3) / 4);
			if (outerSize < tableSize) {
				$(".hMenu").css("width", outerSize + "px");
			} else {
				$(".hMenu").css("width", tableSize + "px");
			}
			d.resolve();
		});
		return d.promise();
	},
	"repeat" : function(str, n) {
		var res = "", i;
		for (i = 0; i < n; i++) {
			res += str;
		}
		return res;
	},
	//RDF.currentの設定でテーブルを作って表示
	"makeTable" : function() {
		var colSize = 12, table, i, j, k, lv1s, lv2s, lv3s, lv1, lv2, lv3;
		if (RDF.current.year === RDF.maxMonth.substr(0, 4)) {
			colSize = Number(RDF.maxMonth.substr(4));
		}
		table = '<table><tr><th></th><th></th>';
		for (i = 1; i < colSize + 1; i++) {
			table += '<th class="data">' + i + '月</th>';
		}
		table += '</tr>';
		lv1s = Object.keys(RDF.tree);
		lv1s.sort();
		for (i = 0; i < lv1s.length; i++) {
			lv1 = lv1s[i];
			if (Object.keys(RDF.tree[lv1]).length === 0) {
				table += '<tr id="' + lv1 + '" class="lv1"><td class="icon"></td><td class="name"></td>' + RDF.repeat('<td></td>', colSize) + '</tr>';
			} else {
				table += '<tr id="' + lv1 + '" class="lv1 hasChild"><td class="icon">+</td><td class="name"></td>' + RDF.repeat('<td></td>', colSize) + '</tr>';
				lv2s = Object.keys(RDF.tree[lv1]);
				lv2s.sort();
				for (j = 0; j < lv2s.length; j++) {
					lv2 = lv2s[j];
					if (Object.keys(RDF.tree[lv1][lv2]).length === 0) {
						table += '<tr id="' + lv2 + '" class="lv2"><td class="icon"></td><td class="name"></td>' + RDF.repeat('<td></td>', colSize) + '</tr>';
					} else {
						table += '<tr id="' + lv2 + '" class="lv2 hasChild"><td class="icon">+</td><td class="name"></td>' + RDF.repeat('<td></td>', colSize) + '</tr>';
						lv3s = Object.keys(RDF.tree[lv1][lv2]);
						lv3s.sort();
						for (k = 0; k < lv3s.length; k++) {
							lv3 = lv3s[k];
							table += '<tr id="' + lv3 + '" class="lv3"><td class="icon"></td><td class="name"></td>' + RDF.repeat('<td></td>', colSize) + '</tr>';
						}
					}
				}
			}
		}
		$("#result").html(table + '</table>');
		$("tr.lv2").css("display", "none");
		$("tr.lv3").css("display", "none");
		$("tr.lv1").each(function() {
			var i;
			RDF.fillName($(this).attr("id"));
			for (i = 1; i <= colSize; i++) {
				RDF.fillData($(this).attr("id"), i, JSON.stringify(RDF.current));
			}
		});
		//子品目を持つ行に子の表示・非表示を切り替えるクリックイベントを設定
		$("tr.hasChild").children(".icon, .name").on("click", function() {
			var child, i, colSize = 12, childRow, grandChild,
				parent = $(this).parent(),
				node = RDF.getNode(parent.attr("id"));
			if (RDF.current.year === RDF.maxMonth.substr(0, 4)) {
				colSize = Number(RDF.maxMonth.substr(4));
			}
			if (parent.children().first().text() === "+") {
				parent.children().first().text("-");
			} else {
				parent.children().first().text("+");
			}
			for (child in node) {
				childRow = $("#" + child);
				if (childRow.css("display") === "none") {
					childRow.css("display", "");
					childRow.children().each(function(index) {
						if (index === 1) {
							RDF.fillName(child);
						} else if (index > 1) {
							RDF.fillData(child, index - 1, JSON.stringify(RDF.current));
						}
					});
				} else {
					childRow.children().first().text("+");
					if (Object.keys(node[child]).length !== 0) {
						for (grandChild in node[child]) {
							$("#" + grandChild).css("display", "none");
						}
					}
					childRow.css("display", "none");
				}
			}
		});
		//品目名にカーソルが乗ったら折り返し許可して全体を表示させる
		$("td.name").on("mouseenter", function() {
			$(this).css("white-space", "normal");
		});
		$("td.name").on("mouseleave", function() {
			$(this).css("white-space", "nowrap");
		});
	}
};

window.onload = function() {
	var deferreds, i, hMenu;
	//getWorksが終わってgetFilesが終わってgetMinとgetMaxが終わったら色々やる
	deferreds = [ RDF.getWorks() ];
	$.when.apply($, deferreds).done(function() {
		deferreds = [];
		for (i = 0; i < RDF.works.length; i++) {
			deferreds.push(RDF.getFiles(RDF.works[i]));
		}
		$.when.apply($, deferreds).done(function() {
			deferreds = [ RDF.getMin(), RDF.getMax() ];
			$.when.apply($, deferreds).done(function() {
				//最小・最大年を元に年選択のメニューを生成
				hMenu = $(".hMenu");
				RDF.current.year = RDF.maxMonth.substr(0, 4);
				hMenu.first().children("span").text(RDF.current.year + "年");
				for (i = RDF.maxMonth.substr(0, 4); i >= RDF.minMonth.substr(0, 4); i--) {
					hMenu.first().children("ul").append('<li id="year-' + i + '" class="vMenu">' + i + '年</li>');
				}
				hMenu.children("ul").css("display", "none");
				hMenu.each(function(index) {
					if (index > 0) {
						$(this).css("border-left", "solid 1px #FFFFFF");
					}
				});
				//オプションが変えられたら保存してテーブル再作成するイベントを設定
				$(".vMenu").on("click", function() {
					var idVal;
					if ($(this).parent().prev().text() !== $(this).text()) {
						idVal = $(this).attr("id").split("-");
						RDF.current[idVal[0]] = idVal[1];
						$(this).parent().prev().text($(this).text());
						RDF.makeTable();
					}
					$(".hMenu img").attr("src", "http://app.linkdata.org/asset/76df76ed.png");
					$(".hMenu span").css("color", "#FFFFFF");
					$(".hMenu ul").slideUp(300);
				});
				$(".vMenu").on({
					"mouseenter" : function() {
						$(this).css("color", "#FFFFFF");
					},
					"mouseleave" : function() {
						$(this).css("color", "#666666");
					}
				});
				//テーブル作成
				RDF.makeTable();
			});
		});
	});
}

//メニューの展開・折り畳み
$("li span").click(function() {
	if ($(this).next().css("display") === "none") {
		$(".hMenu img").attr("src", "http://app.linkdata.org/asset/64da7294.png");
		$(".hMenu span").css("color", "#666666");
		$(".hMenu ul").slideUp(300);
		$(this).next().slideDown(300);
	} else {
		$(".hMenu img").attr("src", "http://app.linkdata.org/asset/76df76ed.png");
		$(".hMenu span").css("color", "#FFFFFF");
		$(".hMenu ul").slideUp(300);
	}
});
